﻿import Table from '@mui/material/Table';
import TableBody from '@mui/material/TableBody';
import TableCell from '@mui/material/TableCell';
import TableContainer from '@mui/material/TableContainer';
import TableHead from '@mui/material/TableHead';
import TableRow from '@mui/material/TableRow';
import Paper from '@mui/material/Paper';
import { BatterStats } from '../types';
import { teamsMap } from '../teamsMap';
export default function BatterStatsTable(rows: { rows: BatterStats[] }) {
    return (
        <TableContainer component={Paper}>
            <Table aria-label="Batter Statistics Table">
                <TableHead>
                    <TableRow>
                        <TableCell><b>Year</b></TableCell>
                        <TableCell><b>Team</b></TableCell>
                        <TableCell><b>Games</b></TableCell>
                        <TableCell><b>At Bats</b></TableCell>
                        <TableCell><b>Hits</b></TableCell>
                        <TableCell><b>Strike Outs</b></TableCell>
                        <TableCell><b>Walks</b></TableCell>
                        <TableCell><b>AVG</b></TableCell>
                        <TableCell><b>OBP</b></TableCell>
                        <TableCell><b>SLG</b></TableCell>
                        <TableCell><b>OPS</b></TableCell>
                    </TableRow>
                </TableHead>
                <TableBody>
                    {rows?.rows?.map((row: BatterStats, index: number) => {
                        const hits = row.b1 + row.b2 + row.b3 + row.hr;
                        const obp = (hits + row.ubb + row.ibb + row.hbp) / (row.ab + row.ubb + row.ibb + row.hbp + row.sf);
                        const slg = ((row.b1 + 2 * row.b2 + 3 * row.b3 + 4 * row.hr) / row.ab);
                        return (
                            <TableRow
                                key={index}
                                sx={{ '&:last-child td, &:last-child th': { border: 0 } }}
                            >
                                <TableCell>{row.yearid}</TableCell>
                                <TableCell>{teamsMap[row.teamid]}</TableCell>
                                <TableCell>{row.g}</TableCell>
                                <TableCell>{row.ab}</TableCell>
                                <TableCell>{hits}</TableCell>
                                <TableCell>{row.so}</TableCell>
                                <TableCell>{row.ibb + row.ubb}</TableCell>
                                <TableCell>{(hits / row.ab).toFixed(3)}</TableCell>
                                <TableCell>{obp.toFixed(3)}</TableCell>
                                <TableCell>{slg.toFixed(2)}</TableCell>
                                <TableCell>{(obp + slg).toFixed(3)}</TableCell>
                            </TableRow>
                        )
                    })}
                </TableBody>
            </Table>
        </TableContainer>
    );
}
