﻿import { useMediaQuery } from 'react-responsive';
import useResize from '../hooks/resizeHook';

import Box from '@mui/material/Box';
import Paper from '@mui/material/Paper';
import BottomNavigation from '@mui/material/BottomNavigation';
import Typography from '@mui/material/Typography';

export default function Footer() {
    const isMobile = useMediaQuery({ maxWidth: 600 });
    useResize();

    const copyrightDO = '© Deniz Ozkaynak';
    const forYankeesConsideration = 'For consideration by the NY Yankees';

    return (
        <Box sx={{ width: 1000 }}>
            <Paper sx={{ position: 'fixed', bottom: 0, left: 0, right: 0 }} elevation={3}>
                <BottomNavigation>
                    {isMobile ?
                        <Typography style={{ textAlign: 'center' }}>
                            {copyrightDO} <br /> {forYankeesConsideration}
                        </Typography>
                        :
                        <Typography style={{ paddingTop: 15 }}>
                            {copyrightDO} | {forYankeesConsideration}
                        </Typography>    
                    }
                    
                </BottomNavigation>
            </Paper>
        </Box>
    );
}