﻿'use client';

import { useMediaQuery } from 'react-responsive';
import useResize from '../hooks/resizeHook';

import { Player } from '../types';
import { positionMap } from '../positionMap';
import { teamsMap } from '../teamsMap';
import { Card, Typography } from '@mui/material';
import CardMedia from '@mui/material/CardMedia';
import CardContent from '@mui/material/CardContent';
import Divider from '@mui/material/Divider';

export default function PlayerCard({ player }: { player: Player | undefined }) {
    const isMobile = useMediaQuery({ maxWidth: 600 });
    useResize();

    function renderNickname(firstname: string | undefined, usesname: string | undefined) {
        return firstname === usesname ? "" : `"${usesname}" `;
    }

    const playerTitle = `${player?.firstname} ${renderNickname(player?.firstname, player?.usesname)}${player?.lastname} #${player?.number}`;

    function convertInchesToFeet(v: number): string {
        const feet = Math.floor(v / 12);
        const inches = v % 12;
        return `${feet}' ${inches}"`;
    }

    return (
        <Card sx={{ maxWidth: 345, maxHeight: 700 }}>
            <CardMedia
                sx={{ height: isMobile ? 300: 445 }}
                image={player?.headshoturl}
                title={`${player?.firstname} ${player?.lastname}`}
            />
            <CardContent>
                <Typography gutterBottom variant="h5" component="div" className="flex justify-center text-center">{playerTitle}</Typography>
                <Divider style={{ paddingBottom: '1px' }} />
                <div className="flex justify-center">
                    <Typography variant="body1">
                        {positionMap[player?.position ? player.position : 0]} | {convertInchesToFeet(player?.height ? player?.height : 0)} | {player?.weight} lbs.
                    </Typography>
                </div>
                <Divider style={{ paddingBottom: '1px' }} />
                <Typography variant="body2" sx={{ color: "text.secondary" }} style={{ paddingTop: '10px' }}>
                    <b>Current Team:</b> {teamsMap[player?.teamid ? player.teamid : 0]}
                </Typography>
                <Typography variant="body2" sx={{ color: "text.secondary" }} style={{ paddingTop: '10px' }}>
                    <b>Birthdate:</b> {player?.birthdate.split(" ")[0]}
                </Typography>
                <Typography variant="body2" sx={{ color: "text.secondary" }} style={{ paddingTop: '10px' }}>
                    <b>Birthplace:</b> {player?.birthcity}, {player?.birthstate} {player?.birthcountry}
                </Typography>
            </CardContent>
        </Card>
    )
}